/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.codexadrian.tempad.TempadClient;
import me.codexadrian.tempad.TempadClientConfig;
import me.codexadrian.tempad.client.gui.TempadScreen;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class OptionsScreen
extends Screen {
    private static final ResourceLocation GRID = new ResourceLocation("tempad", "textures/widget/tempad_grid.png");
    private final InteractionHand hand;
    private int color;
    private static final int WIDTH = 480;
    private static final int HEIGHT = 256;

    public OptionsScreen(int color, InteractionHand hand) {
        super(Component.m_130674_((String)""));
        this.color = color;
        this.hand = hand;
    }

    protected void m_7856_() {
        super.m_7856_();
        int colorPerRow = 10;
        int margin = 6;
        int scale = 32;
        int startX = (this.f_96543_ - 480) / 2 + 48 + 5;
        int startY = (this.f_96544_ - 256) / 2 + 80 + 2;
        int x = 0;
        int y = 0;
        int[] colors = TempadClient.getClientConfig().getColorOptions();
        for (int i = 0; i < colors.length; ++i) {
            int finalI = i;
            ColorButton button = new ColorButton(x + startX, y + startY, scale, colors[i] | 0xFF000000, button1 -> {
                this.color = colors[finalI];
                TempadClient.getClientConfig().setColor(this.color);
                TempadClientConfig.saveConfig(TempadClient.getClientConfig());
            });
            this.m_142416_((GuiEventListener)button);
            x += scale + margin;
            if ((i + 1) % colorPerRow != 0) continue;
            x = 0;
            y += scale + margin;
        }
    }

    private void renderOutline(PoseStack poseStack) {
        int lineWidth = 4;
        OptionsScreen.m_93172_((PoseStack)poseStack, (int)((this.f_96543_ - 480 - lineWidth) / 2), (int)((this.f_96544_ - 256 - lineWidth) / 2), (int)((this.f_96543_ + 480 + lineWidth) / 2), (int)((this.f_96544_ + 256 + lineWidth) / 2), (int)(this.color | 0xFF000000));
    }

    private void renderGridBackground(PoseStack poseStack, float red, float green, float blue) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GRID);
        RenderSystem.m_157429_((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        OptionsScreen.m_93160_((PoseStack)poseStack, (int)((this.f_96543_ - 480) / 2), (int)((this.f_96544_ - 256) / 2), (int)480, (int)256, (float)0.0f, (float)0.0f, (int)480, (int)256, (int)16, (int)16);
    }

    public void m_96558_(PoseStack poseStack, int offset) {
        super.m_96558_(poseStack, offset);
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderOutline(poseStack);
        this.renderGridBackground(poseStack, red, green, blue);
        this.renderHeaders(poseStack);
    }

    private void renderHeaders(PoseStack matrices) {
        Font font = this.f_96541_.f_91062_;
        int cornerX = (this.f_96543_ - 480) / 2 + 3;
        int cornerY = (this.f_96544_ - 256) / 2 + 7;
        int x = cornerX + 48;
        int y = cornerY + 32;
        matrices.m_85836_();
        matrices.m_85837_((double)x * -1.2, (double)y * -1.2, 0.0);
        matrices.m_85841_(2.2f, 2.2f, 0.0f);
        OptionsScreen.m_93243_((PoseStack)matrices, (Font)font, (Component)new TranslatableComponent("gui.tempad.options_header"), (int)x, (int)y, (int)this.color);
        matrices.m_85849_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)new TempadScreen(this.color, this.hand));
    }

    public static class ColorButton
    extends Button {
        private final int buttonColor;

        public ColorButton(int x, int y, int size, int buttonColor, Button.OnPress onPress) {
            super(x, y, size, size, Component.m_130674_((String)""), onPress);
            this.buttonColor = buttonColor;
        }

        public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
            matrices.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ColorButton.m_93172_((PoseStack)matrices, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + 1 + this.f_93618_), (int)(this.f_93621_ + 1 + this.f_93619_), (int)-1);
            ColorButton.m_93172_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)this.buttonColor);
            matrices.m_85849_();
        }
    }
}

